package gov.va.med.mhv.vitals.repository;

import gov.va.med.mhv.vitals.model.PainReading;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PainReadingRepository extends JpaRepository<PainReading, Long>{
	
    @Query("select a from PainReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<PainReading>  getPainReadingsForUser(@Param ("userprofileid") Long userprofileid);
    
    
    @Query("select a from PainReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<PainReading>  getDashBoardPainReadingsForUser(@Param ("userprofileid") Long userprofileid,Pageable page);



}
